using UnityEngine;
using System.Collections;

public class s_AnimationBase : MonoBehaviour
{
	public Texture2D[] mAnimation;	//Sets the animation frames. First one must be still animation.
	public Texture2D mDeadTexture;	//Dead texture
	public float mAnimationSpeed;	//How fast it goes through the frames. Is / by time, so smaller is faster
	[System.NonSerialized][HideInInspector]
	public float mMoveTol = 0.005f;//A tolerance for checking if you moved. Public because enemy uses different tolerance
	
	float mCurXPos = 0;				//Current x position
	float mPreXPos = 0;				//Previous x position, both used to check if you have moved
	int mCurAnimFrame = 0;			//Which animation frame you are on
	float mTimeToNextFrame = 0;		//Gets set to the animation speed and determines how fast the animation goes.
	bool mHaveRewind = false;		//This checks if you have the rewind script on, to check if rewind logic should be applied
	bool mMoved = false;			//Checks if you have moved
	bool mChangeDir = false;		//Checks if the rewind paused. For correcting animation when changing from rewind to rewind of rewind
	bool mStartRewind = false;		//Checks if the rewind just started
	
	bool mDead = false;				//If dead, don't update animation
	
	void Start()
	{
		if (GetComponent<s_Rewindable>() != null)
			mHaveRewind = true;
		
		mTimeToNextFrame = mAnimationSpeed;
		
		s_TimeManager.Get.AddStartFunction(RewindStart);
	}
	
	void Update()
	{
		if (mDead)
			return;
		
		mCurXPos = transform.localPosition.x;
		
		//If have moved, update animation, otherwise reset it
		if(mCurXPos - mPreXPos > mMoveTol || mCurXPos - mPreXPos < -mMoveTol)
			UpdateAnimation();
		else if (mMoved)
			ResetAnimation();
		
		mPreXPos = mCurXPos;	
	}
	
	void UpdateAnimation()
	{
		mTimeToNextFrame -= Mathf.Abs(Time.deltaTime*s_TimeManager.sRewindSpeed);
		
		//Horizontal flip check when moving
		HorizontalFlip();
		
		//Change current frame; goes up or down depending on if you are rewinding. Only done every couple of frames.
		if (mTimeToNextFrame <= 0)
		{
			//Changes animation frames depending on rewind
			if (s_TimeManager.sRewindSpeed < 0 && mHaveRewind)
				--mCurAnimFrame;
			else
				++mCurAnimFrame;
			
			if (mCurAnimFrame >= mAnimation.Length)
				mCurAnimFrame = 0;
			else if (mCurAnimFrame < 0)
				mCurAnimFrame = mAnimation.Length-1;
			
			//Change the texture
			renderer.material.mainTexture = mAnimation[mCurAnimFrame];
			
			mTimeToNextFrame = mAnimationSpeed;
			mMoved = true;
			mStartRewind = false;
		}	
	}
	
	void ResetAnimation()
	{
		if (Time.timeScale == 0)
			mChangeDir = true;
		
		//Don't reset animation if you are moving, or if you were paused by the rewind
		if (!mStartRewind || s_TimeManager.sRewind)
		if (Time.timeScale != 0)
		{
			if (mChangeDir)
			{
				mChangeDir = false;
				return;
			}
			
			mCurAnimFrame = 0;
			renderer.material.mainTexture = mAnimation[mCurAnimFrame];
			mMoved = false;
		}
	}
	
	void HorizontalFlip()
	{	
		if (Time.timeScale == 0)
			return;
		
		//Flip you depending on which way you are moving and if you are rewinding or not
		if (mHaveRewind && s_TimeManager.sRewind && s_TimeManager.sRewindSpeed < 0 && !mStartRewind)
		{
			//Flip rewind direction
			if (mCurXPos - mPreXPos < mMoveTol && transform.localScale.x > 0)
				transform.localScale = new Vector3(transform.localScale.x * -1, transform.localScale.y, transform.localScale.z);
			else if (mCurXPos - mPreXPos > -mMoveTol && transform.localScale.x < 0)
				transform.localScale = new Vector3(transform.localScale.x * -1, transform.localScale.y, transform.localScale.z);
		}
		else
		{
			//Flip regular direction
			if (mCurXPos - mPreXPos < -mMoveTol && transform.localScale.x < 0)
				transform.localScale = new Vector3(transform.localScale.x * -1, transform.localScale.y, transform.localScale.z);
			else if (mCurXPos - mPreXPos > mMoveTol && transform.localScale.x > 0)
				transform.localScale = new Vector3(transform.localScale.x * -1, transform.localScale.y, transform.localScale.z);
		}
		
		mStartRewind = false;
	}
	
	public void Dead()
	{
		mDead = true;
		renderer.material.mainTexture = mDeadTexture;	
	}
	
	public void Revive()
	{
		mDead = false;
		mCurAnimFrame = 0;
		renderer.material.mainTexture = mAnimation[mCurAnimFrame];
	}
	
	public void RewindStart()
	{
		mStartRewind = true;
	}
	
}
